RoadCraftChangeGroundTypeEvent = {}
local RoadCraftChangeGroundTypeEvent_mt = Class(RoadCraftChangeGroundTypeEvent, Event)

InitEventClass(RoadCraftChangeGroundTypeEvent, "RoadCraftChangeGroundTypeEvent")

function RoadCraftChangeGroundTypeEvent.emptyNew()
    return Event.new(RoadCraftChangeGroundTypeEvent_mt)
end

function RoadCraftChangeGroundTypeEvent.new(vehicle, groundType)
    local self = RoadCraftChangeGroundTypeEvent.emptyNew()
    self.vehicle = vehicle
    self.groundType = groundType
    return self
end

function RoadCraftChangeGroundTypeEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.vehicle)
    RoadCraftTrailer.streamWriteGroundType(streamId, self.groundType)
end

function RoadCraftChangeGroundTypeEvent:readStream(streamId, connection)
    self.vehicle = NetworkUtil.readNodeObject(streamId)
    self.groundType = RoadCraftTrailer.streamReadGroundType(streamId)
    self:run(connection)
end

function RoadCraftChangeGroundTypeEvent:run(connection)
    if not connection:getIsServer() then
        g_server:broadcastEvent(self, false, connection, self.vehicle)
    end

    if self.vehicle ~= nil then
        self.vehicle:setGroundType(self.groundType, true)
    end
end

function RoadCraftChangeGroundTypeEvent.sendEvent(vehicle, groundType, noEventSend)
    if noEventSend == nil or noEventSend == false then
        if g_server ~= nil then
            g_server:broadcastEvent(RoadCraftChangeGroundTypeEvent.new(vehicle, groundType), nil, nil, vehicle)
        else
            g_client:getServerConnection():sendEvent(RoadCraftChangeGroundTypeEvent.new(vehicle, groundType))
        end
    end
end