RoadCraftChangeStrengthEvent = {}
local RoadCraftChangeStrengthEvent_mt = Class(RoadCraftChangeStrengthEvent, Event)

InitEventClass(RoadCraftChangeStrengthEvent, "RoadCraftChangeStrengthEvent")

function RoadCraftChangeStrengthEvent.emptyNew()
    return Event.new(RoadCraftChangeStrengthEvent_mt)
end

function RoadCraftChangeStrengthEvent.new(vehicle, strengthFactor)
    local self = RoadCraftChangeStrengthEvent.emptyNew()
    self.vehicle = vehicle
    self.strengthFactor = strengthFactor
    return self
end

function RoadCraftChangeStrengthEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.vehicle)
    RoadCraftTrailer.streamWriteStrengthFactor(streamId, self.strengthFactor)
end

function RoadCraftChangeStrengthEvent:readStream(streamId, connection)
    self.vehicle = NetworkUtil.readNodeObject(streamId)
    self.strengthFactor = RoadCraftTrailer.streamReadStrengthFactor(streamId)
    self:run(connection)
end

function RoadCraftChangeStrengthEvent:run(connection)
    if not connection:getIsServer() then
        g_server:broadcastEvent(self, false, connection, self.vehicle)
    end

    if self.vehicle ~= nil then
        self.vehilce:setStrengthFactor(self.strengthFactor, true)
    end
end

function RoadCraftChangeStrengthEvent.sendEvent(vehicle, strengthFactor, noEventSend)
    if noEventSend == nil or noEventSend == false then
        if g_server ~= nil then
            g_server:broadcastEvent(RoadCraftChangeStrengthEvent.new(vehicle, strengthFactor), nil, nil, vehicle)
        else
            g_client:getServerConnection():sendEvent(RoadCraftChangeStrengthEvent.new(vehicle, strengthFactor))
        end
    end
end