
--

VineCutterFruits = {};

function VineCutterFruits.initSpecialization()
    local schema = Vehicle.xmlSchema;

    schema:setXMLSpecializationType("VineCutterFruits");
    schema:register(XMLValueType.STRING, "vehicle.vineCutter#fruitTypes", "Fruit types");
    schema:setXMLSpecializationType();
end

function VineCutterFruits.prerequisitesPresent (specializations)
    return SpecializationUtil.hasSpecialization(VineCutter, specializations);
end

function VineCutterFruits.registerFunctions(vehicleType)
    SpecializationUtil.registerFunction(vehicleType, "fruitTypeIsValid", VineCutterFruits.fruitTypeIsValid);
end


function VineCutterFruits.registerOverwrittenFunctions(vehicleType)
    SpecializationUtil.registerOverwrittenFunction(vehicleType, "getIsValidVinePlaceable", VineCutterFruits.getIsValidVinePlaceable);
end

function VineCutterFruits.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onLoad", VineCutterFruits);
end

function VineCutterFruits:onLoad(savegame)
    local spec = self.spec_vineCutter;
    local fruitTypes = self.xmlFile:getValue("vehicle.vineCutter#fruitTypes");
    
    if fruitTypes == nil then
        fruitTypes = " ";
    else
        fruitTypes = fruitTypes:split(" ");
    end

    self.vineCutterFruitTypes = {};

    for i, fruitTypeName in pairs(fruitTypes) do
        local fruitType = g_fruitTypeManager:getFruitTypeByName(fruitTypeName);

        if fruitType ~= nil then
            table.insert(self.vineCutterFruitTypes, fruitType.index);
        end
    end
end

function VineCutterFruits:getIsValidVinePlaceable(superFunc, placeable)
    if placeable == nil then
        return false;
    end

    local spec = self.spec_vineCutter;
    local vineFruitType = placeable:getVineFruitType();

    if not self:fruitTypeIsValid(vineFruitType) then
        return false;
    end

    spec.inputFruitTypeIndex = vineFruitType;
    spec.outputFillTypeIndex = g_fruitTypeManager:getFillTypeIndexByFruitTypeIndex(spec.inputFruitTypeIndex);

    return true;
end

function VineCutterFruits:fruitTypeIsValid(cutterFruitType)
    for _, vineCutterFruitType in pairs(self.vineCutterFruitTypes) do
        if vineCutterFruitType == cutterFruitType then
            return true;
        end
    end

    return false;
end